<?php

function is_cluster_existing($argv) {
    global $DTASCFG_XML_FILE, $BACKEND;
    
    /* check number of arguments */
	if(count($argv) != 1) {
	    echo "Usage: is_cluster_existing CLUSTER_NAME ESXI_IP\n";
        exit(1);
    }
    
    $existed = 0;
    $esxi_ip = $argv[0];
	
	$xml = simplexml_load_file($DTASCFG_XML_FILE);
    $db_host = chop($xml->db->host);
    $db_user = chop($xml->db->username);
    $db_password =  $xml->db->password;
    
    if(($db_connect = pg_connect("host=$db_host dbname=dtasdb port=5432 user=$db_user password=$db_password")) == FALSE) {
        echo "Failed to connect to database\n";
        exit(1);
    }
    
    $result = pg_query_params($db_connect, 'SELECT sc_id FROM tb_sc_info', array());
    $cluster_ids = pg_fetch_all($result);
    
	foreach ($cluster_ids as $cluster_id) {
	    $xpath = "/configuration/cluster_" . $cluster_id["sc_id"] . "/esxi/ip";
	    $existing_cluster_ip = $xml->xpath($xpath);                

        if(count($existing_cluster_ip))
        {            
            if($existing_cluster_ip[0] == $esxi_ip) {
                $existed = 1;
                break;
            }
        }
    }
    
    if( $db_connect !== false ) {
        pg_close( $db_connect ) ;
    }

	exit(($existed == 1) ? 0 : 1);
}
